 /* 'ConLib.cpp' */

 /* Komplementarny plik nagwka ConLib  */
#include "ConLib.h"

 /* Pobierz standardowe uchwyty klawiatury i ekranu */
ConLib::ConLib ()
{
 m_Screen = GetStdHandle (STD_OUTPUT_HANDLE);
 m_Keyboard = GetStdHandle (STD_INPUT_HANDLE);
 
 SetTextColor (ConRed | ConGreen | ConBlue);
 SetBackgroundColor (0);
}

 /* Destruktor nie robi nic */
ConLib::~ConLib ()
{

}

 /* Sets background color */
void ConLib::SetBackgroundColor (WORD Color)
{
 m_BackgroundColor = 0;

  /* Uyj manipulacji na bitach by otrzyma kombinacje kolorw */
 if (Color & ConRed)
 {
  m_BackgroundColor |= BACKGROUND_RED;
 }
 if (Color & ConGreen)
 {
  m_BackgroundColor |= BACKGROUND_GREEN;
 }
 if (Color & ConBlue)
 {
  m_BackgroundColor |= BACKGROUND_BLUE;
 }

  /* Ustaw kolor korzystajc z powyszych kombinacji */
 SetConsoleTextAttribute (m_Screen, m_TextColor | m_BackgroundColor);
}


 /* Ustawia kolor tekstu */
void ConLib::SetTextColor (WORD Color)
{
 m_TextColor = 0;

  /* Uyj manipulacji na bitach by otrzyma kombinacje kolorw */
 if (Color & ConRed)
 {
  m_TextColor |= FOREGROUND_RED;
 }
 if (Color & ConGreen)
 {
  m_TextColor |= FOREGROUND_GREEN;
 }
 if (Color & ConBlue)
 {
  m_TextColor |= FOREGROUND_BLUE;
 }

  /* Ustaw kolor korzystajc z powyszych kombinacji */
 SetConsoleTextAttribute (m_Screen, m_TextColor | m_BackgroundColor);
}

 /* Ustawia nazw okna */
void ConLib::SetTitle (char * Title)
{
 SetConsoleTitle (Title);
}

 /* Zeruje ekran */
void ConLib::Clear (void)
{
 COORD Start;
 DWORD Written;

 Start.X = 0;
 Start.Y = 0;

 FillConsoleOutputAttribute (m_Screen, m_TextColor | m_BackgroundColor, 
                             80*25, Start, &Written);
 FillConsoleOutputCharacter (m_Screen, ' ', 
                             80*25, Start, &Written);
 SetConsoleCursorPosition (m_Screen, Start);
}

 /* Ustawia pozycj kursora */
void ConLib::SetPosition (COORD Position)
{
 SetConsoleCursorPosition (m_Screen, Position);
}

 /* Wysya acuch na ekran */
void ConLib::OutputString (char * String)
{
 DWORD Written;

 WriteConsole (m_Screen, String, strlen (String), &Written, NULL);
}

 /* Odczytuje acuch z klawiatury */
void ConLib::Read (char * Buffer, DWORD BufferSize)
{
 DWORD Read;

 ReadConsole (m_Keyboard, Buffer, BufferSize, &Read, NULL);
}


 /* Pobiera nacinity klawisz */
int ConLib::GetKey (void)
{
 DWORD Read;
 INPUT_RECORD Event;

  /* Odczytuje wejcie konsoli */
 ReadConsoleInput (m_Keyboard, &Event, 1, &Read);

  /* Jeeli zdarzenie wejciowe dotyczy klawiatury, sprawdza czy nacinity zosta klawisz
     i zwraca jego kod wirtualny */
 if (Event.EventType == KEY_EVENT)
 {
  if (Event.Event.KeyEvent.bKeyDown)
  {
   return Event.Event.KeyEvent.wVirtualKeyCode;
  }
 }

 return 0;
}
